class US_BaseMutator extends DMMutator config(UniversalSoldiers);

//game vars:
var DeathMatchPlus MyGame;
var int count;

function PostBeginPlay() 
{
	MyGame = DeathMatchPlus(Level.Game);

	SetTimer(1.0,True);

	Super.PostBeginPlay();

	AddMutator(Level.Spawn(class'US_StatsMutator'));
	AddMutator(Level.Spawn(class'US_ScoringMutator'));
	AddMutator(Level.Spawn(class'US_LevelMutator'));
	AddMutator(Level.Spawn(class'IP2Country'));
}

function Timer()
{
	Super.Timer();
	ItemControl();	//Regen Health/Armor/Ammo accordingly to players variables
	RelicControl(); //Aura Relic, Health regen Relic
	CyclePickups();	//countdown LifeTime of pickups
}

function CyclePickups()
{
local UniversalSoldiersPickup U;

	ForEach AllActors(class'UniversalSoldiersPickup', U)
		{
		if ( U.IsA('Pickup_HealthPoint') || U.IsA('Pickup_SuperHealthPoint') || U.IsA('Pickup_Soul'))
			{
			U.LifeTime--;
			if ( U.LifeTime < 0 )
				{
				spawn(class'UT_SpriteSmokePuff',,,U.Location);
				U.Destroy();
				}
			}
		}
}

function RelicControl()
{
local Pawn P, Enemy;
local UT_SpriteSmokePuff SP;
local UT_BloodBurst BB;
local Vector FireSpot, ProjStart;
local Projectile proj;

	for (P = Level.PawnList; P != None; P = P.NextPawn)
		{
		if ( P.IsA('PlayerPawn'))
			{
			//fix to compensate the JumpZ:
			if ( P.JumpZ < P.Default.JumpZ * 1.1 )
				P.JumpZ = P.Default.JumpZ * 1.1;

			if ( US_PRI(P.PlayerReplicationInfo).bHasAura )
				{
				foreach VisibleCollidingActors(class'Pawn', Enemy, 400, P.Location, true)
					{
					if ( P != Enemy )
						{
						Enemy.TakeDamage(7, P, Enemy.Location, vect(0,0,0), 'aura');
						SP = spawn(class'UT_SpriteSmokePuff',,,Enemy.Location);
						SP.DrawScale = 3;
						BB = spawn(class'UT_BloodBurst',,,Enemy.Location);
						BB.DrawScale = 1;
						}
					}
				}
			if ( US_PRI(P.PlayerReplicationInfo).bHasHealthRegenRelic )
				{
				if ( P.Health < US_PRI(P.PlayerReplicationInfo).BaseHealth * 2 )
					{
					P.Health++;
					}
				}
			}
		/* Hack to ensure scripted pawns doesn't run out of ammo */
		else if ( P.IsA('ScriptedPawn'))
			{
			if (P.Weapon != None)
				{
				if ( P.Weapon.AmmoType != None )
					{
					P.Weapon.AmmoType.AmmoAmount = 50;
					}
				}
			}
		}
}

function ItemControl()
{
local Pawn P;
Local inventory Inv;
local UniversalSoldiersWeapon Weap;
local string KeyName,ID,Value,NewValue;

	for (P = Level.PawnList; P != None; P = P.NextPawn)
		{
		if ( P.IsA('PlayerPawn'))
			{
			if ( US_PRI(P.PlayerReplicationInfo).bHasHealthRegen )
				{
				if ( P.Health < US_PRI(P.PlayerReplicationInfo).BaseHealth )
					{
					P.Health++;
					}
				}
			if ( US_PRI(P.PlayerReplicationInfo).bHasArmorRegen )
				{
				for( Inv=P.Inventory; Inv!=None; Inv=Inv.Inventory )
					{ 
					if (Inv.bIsAnArmor) 
						{
						if ( Inv.Charge < Inv.Default.Charge )
							{
							Inv.Charge++;
							}
						}
					}
				}
			if ( US_PRI(P.PlayerReplicationInfo).bHasAmmoRegen && count == 2)
				{
				for( Inv=P.Inventory; Inv!=None; Inv=Inv.Inventory )
					{ 
					if (Inv.IsA('UniversalSoldiersWeapon')) 
						{
						Weap = UniversalSoldiersWeapon(Inv);
						if ( Weap.AmmoType.AmmoAmount < Weap.AmmoType.MaxAmmo )
							{
							Weap.AmmoType.AmmoAmount++;
							}
						}
					}
				}
			}
		}
	count++;
	if ( count > 2)
		count = 0;
}

function bool AlwaysKeep(Actor Other) 
{
	
	if (Other.IsA('PlayerPawn'))
        	{
		PlayerPawn(Other).PlayerReplicationInfoClass = class'US_PRI';
		return true;
		}
	if (Other.IsA('Bot'))
        	{
		Bot(Other).PlayerReplicationInfoClass = class'US_PRI';
		return true;
		}
	if (Other.IsA('Pickup_Ammo'))
        	{
		Other.DrawScale = 0.25;
		return true;
		}
	if (Other.IsA('Carcass'))
		{
		Carcass(Other).Style = STY_Translucent;
		Carcass(Other).bProjTarget = False;
		Carcass(Other).bBlockPlayers = False;
		}
	if (NextMutator != None)
		return (NextMutator.AlwaysKeep(Other));
	
	return false;
}


function ModifyPlayer(Pawn P)
{
local US_PRI IPRI;

	if ( P.IsA('PlayerPawn'))
		{
		PlayerPawn(P).PlayerReplicationInfo.Team = 0;
		PlayerPawn(P).Health = US_PRI(PlayerPawn(P).PlayerReplicationInfo).BaseHealth;
		PlayerPawn(P).SetDefaultDisplayProperties();
		PlayerPawn(P).bJustFired = False;
		PlayerPawn(P).bJustAltFired = False;
 		}
	else if ( P.IsA('Bot'))
		{
		Bot(P).PlayerReplicationInfo.Team = 0;
		Bot(P).SetDefaultDisplayProperties();
		}

	if ( P.Inventory != None )
		P.Inventory.SetOwnerDisplay();

	if (NextMutator != None)
		NextMutator.ModifyPlayer(P);

}


function Mutate(string MutateString, PlayerPawn Sender)
{
local US_PRI IPRI;
local Inventory Inv;


	if ( Right(MutateString,10) ~= "NextPlayer" && US_PRI(Sender.PlayerReplicationInfo).bChoseCharacter == True )
		{
		Sender.PlaySound (Sound'BotPack.flak.Click',,2.0);
		US_PRI(Sender.PlayerReplicationInfo).bHasAmmoRegen = False;
		US_PRI(Sender.PlayerReplicationInfo).bHasHealthRegen = False;
		US_PRI(Sender.PlayerReplicationInfo).bHasArmorRegen = False;

		if (US_PRI(Sender.PlayerReplicationInfo).PlayerModel == "Freezy")
			{
			US_PRI(Sender.PlayerReplicationInfo).PlayerModel = "Cyborg";
			US_PRI(Sender.PlayerReplicationInfo).BaseWeapon = "Enforcer";
			}
		else if (US_PRI(Sender.PlayerReplicationInfo).PlayerModel == "Cyborg")
			{
			US_PRI(Sender.PlayerReplicationInfo).PlayerModel = "Hitman";
			US_PRI(Sender.PlayerReplicationInfo).BaseWeapon = "SniperRifle";
			}
		else if (US_PRI(Sender.PlayerReplicationInfo).PlayerModel == "Hitman")
			{
			US_PRI(Sender.PlayerReplicationInfo).PlayerModel = "Snake";
			US_PRI(Sender.PlayerReplicationInfo).BaseWeapon = "MiniGun";
			}
		else if (US_PRI(Sender.PlayerReplicationInfo).PlayerModel == "Snake")
			{
			US_PRI(Sender.PlayerReplicationInfo).PlayerModel = "Trooper";
			US_PRI(Sender.PlayerReplicationInfo).BaseWeapon = "FlakCannon";
			}
		else if (US_PRI(Sender.PlayerReplicationInfo).PlayerModel == "Trooper")
			{
			US_PRI(Sender.PlayerReplicationInfo).PlayerModel = "Vampire";
			US_PRI(Sender.PlayerReplicationInfo).BaseWeapon = "RazorJack";
			}
		else if (US_PRI(Sender.PlayerReplicationInfo).PlayerModel == "Vampire")
			{
			US_PRI(Sender.PlayerReplicationInfo).PlayerModel = "Tensor";
			US_PRI(Sender.PlayerReplicationInfo).BaseWeapon = "ShockRifle";
			}
		else if (US_PRI(Sender.PlayerReplicationInfo).PlayerModel == "Tensor")
			{
			US_PRI(Sender.PlayerReplicationInfo).PlayerModel = "Cyclop";
			US_PRI(Sender.PlayerReplicationInfo).BaseWeapon = "RocketLauncher";
			}
		else if (US_PRI(Sender.PlayerReplicationInfo).PlayerModel == "Cyclop")
			{
			US_PRI(Sender.PlayerReplicationInfo).PlayerModel = "Ninja";
			US_PRI(Sender.PlayerReplicationInfo).BaseWeapon = "BioRifle";
			}
		else if (US_PRI(Sender.PlayerReplicationInfo).PlayerModel == "Ninja")
			{
			US_PRI(Sender.PlayerReplicationInfo).PlayerModel = "Gordon";
			US_PRI(Sender.PlayerReplicationInfo).BaseWeapon = "PulseGun";
			}
		else if (US_PRI(Sender.PlayerReplicationInfo).PlayerModel == "Gordon")
			{
			US_PRI(Sender.PlayerReplicationInfo).PlayerModel = "Freezy";
			US_PRI(Sender.PlayerReplicationInfo).BaseWeapon = "ShockRifle";
			}
		US_PRI(Sender.PlayerReplicationInfo).bGrabStats = True;
		}
	else if ( Right(MutateString,10) ~= "PrevPlayer" && US_PRI(Sender.PlayerReplicationInfo).bChoseCharacter == True )
		{
		Sender.PlaySound (Sound'BotPack.flak.Click',,2.0);
		US_PRI(Sender.PlayerReplicationInfo).bHasAmmoRegen = False;
		US_PRI(Sender.PlayerReplicationInfo).bHasHealthRegen = False;
		US_PRI(Sender.PlayerReplicationInfo).bHasArmorRegen = False;
		if (US_PRI(Sender.PlayerReplicationInfo).PlayerModel == "Freezy")
			{
			US_PRI(Sender.PlayerReplicationInfo).PlayerModel = "Gordon";
			US_PRI(Sender.PlayerReplicationInfo).BaseWeapon = "PulseGun";
			}
		else if (US_PRI(Sender.PlayerReplicationInfo).PlayerModel == "Gordon")
			{
			US_PRI(Sender.PlayerReplicationInfo).PlayerModel = "Ninja";
			US_PRI(Sender.PlayerReplicationInfo).BaseWeapon = "BioRifle";
			}
		else if (US_PRI(Sender.PlayerReplicationInfo).PlayerModel == "Ninja")
			{
			US_PRI(Sender.PlayerReplicationInfo).PlayerModel = "Cyclop";
			US_PRI(Sender.PlayerReplicationInfo).BaseWeapon = "RocketLauncher";
			}
		else if (US_PRI(Sender.PlayerReplicationInfo).PlayerModel == "Cyclop")
			{
			US_PRI(Sender.PlayerReplicationInfo).PlayerModel = "Tensor";
			US_PRI(Sender.PlayerReplicationInfo).BaseWeapon = "ShockRifle";
			}
		else if (US_PRI(Sender.PlayerReplicationInfo).PlayerModel == "Tensor")
			{
			US_PRI(Sender.PlayerReplicationInfo).PlayerModel = "Vampire";
			US_PRI(Sender.PlayerReplicationInfo).BaseWeapon = "RazorJack";
			}
		else if (US_PRI(Sender.PlayerReplicationInfo).PlayerModel == "Vampire")
			{
			US_PRI(Sender.PlayerReplicationInfo).PlayerModel = "Trooper";
			US_PRI(Sender.PlayerReplicationInfo).BaseWeapon = "FlakCannon";
			}
		else if (US_PRI(Sender.PlayerReplicationInfo).PlayerModel == "Trooper")
			{
			US_PRI(Sender.PlayerReplicationInfo).PlayerModel = "Snake";
			US_PRI(Sender.PlayerReplicationInfo).BaseWeapon = "MiniGun";
			}
		else if (US_PRI(Sender.PlayerReplicationInfo).PlayerModel == "Snake")
			{
			US_PRI(Sender.PlayerReplicationInfo).PlayerModel = "Hitman";
			US_PRI(Sender.PlayerReplicationInfo).BaseWeapon = "SniperRifle";
			}
		else if (US_PRI(Sender.PlayerReplicationInfo).PlayerModel == "Hitman")
			{
			US_PRI(Sender.PlayerReplicationInfo).PlayerModel = "Cyborg";
			US_PRI(Sender.PlayerReplicationInfo).BaseWeapon = "Enforcer";
			}
		else if (US_PRI(Sender.PlayerReplicationInfo).PlayerModel == "Cyborg")
			{
			US_PRI(Sender.PlayerReplicationInfo).PlayerModel = "Freezy";
			US_PRI(Sender.PlayerReplicationInfo).BaseWeapon = "ShockRifle";
			}
		US_PRI(Sender.PlayerReplicationInfo).bGrabStats = True;
		}
	else if ( Right(MutateString,12) ~= "SelectPlayer" && US_PRI(Sender.PlayerReplicationInfo).bChoseCharacter == True )
		{
		Sender.PlaySound (Sound'UnrealI.Generic.RespawnSound',,2.0);
		US_PRI(Sender.PlayerReplicationInfo).bChoseCharacter = False;
		log("Player:"@Sender.PlayerReplicationInfo.PlayerName$" chose new character:"@US_PRI(Sender.PlayerReplicationInfo).PlayerModel);

		if (US_PRI(Sender.PlayerReplicationInfo).PlayerModel == "Freezy")
			{
			Sender.MultiSkins[0] = Texture'Freezy1';
			Sender.MultiSkins[1] = Texture'Freezy2';
			Sender.MultiSkins[2] = Texture'Freezy3';
			Sender.MultiSkins[3] = Texture'Freezy4';
			Sender.PlayerReplicationInfo.TalkTexture = Texture'Freezy5';
			}
		else if (US_PRI(Sender.PlayerReplicationInfo).PlayerModel == "Cyborg")
			{
			Sender.MultiSkins[0] = Texture'Cyborg1';
			Sender.MultiSkins[1] = Texture'Cyborg2';
			Sender.MultiSkins[2] = Texture'Cyborg3';
			Sender.MultiSkins[3] = Texture'Cyborg4';
			Sender.PlayerReplicationInfo.TalkTexture = Texture'Cyborg5';
			}
		else if (US_PRI(Sender.PlayerReplicationInfo).PlayerModel == "Hitman")
			{
			Sender.MultiSkins[0] = Texture'Hitman1';
			Sender.MultiSkins[1] = Texture'Hitman2';
			Sender.MultiSkins[2] = Texture'Hitman3';
			Sender.MultiSkins[3] = Texture'Hitman4';
			Sender.PlayerReplicationInfo.TalkTexture = Texture'Hitman5';
			}
		else if (US_PRI(Sender.PlayerReplicationInfo).PlayerModel == "Snake")
			{
			Sender.MultiSkins[0] = Texture'Snake1';
			Sender.MultiSkins[1] = Texture'Snake2';
			Sender.MultiSkins[2] = Texture'Snake3';
			Sender.MultiSkins[3] = Texture'Snake4';
			Sender.PlayerReplicationInfo.TalkTexture = Texture'Snake5';
			}
		else if (US_PRI(Sender.PlayerReplicationInfo).PlayerModel == "Trooper")
			{
			Sender.MultiSkins[0] = Texture'Trooper1';
			Sender.MultiSkins[1] = Texture'Trooper2';
			Sender.MultiSkins[2] = Texture'Trooper3';
			Sender.MultiSkins[3] = Texture'Trooper4';
			Sender.PlayerReplicationInfo.TalkTexture = Texture'Trooper5';
			}
		else if (US_PRI(Sender.PlayerReplicationInfo).PlayerModel == "Vampire")
			{
			Sender.MultiSkins[0] = Texture'Vampire1';
			Sender.MultiSkins[1] = Texture'Vampire2';
			Sender.MultiSkins[2] = Texture'Vampire3';
			Sender.MultiSkins[3] = Texture'Vampire4';
			Sender.PlayerReplicationInfo.TalkTexture = Texture'Vampire5';
			}
		else if (US_PRI(Sender.PlayerReplicationInfo).PlayerModel == "Tensor")
			{
			Sender.MultiSkins[0] = Texture'Tensor1';
			Sender.MultiSkins[1] = Texture'Tensor2';
			Sender.MultiSkins[2] = Texture'Tensor3';
			Sender.MultiSkins[3] = Texture'Tensor4';
			Sender.PlayerReplicationInfo.TalkTexture = Texture'Tensor5';
			}
		else if (US_PRI(Sender.PlayerReplicationInfo).PlayerModel == "Cyclop")
			{
			Sender.MultiSkins[0] = Texture'Cyclop1';
			Sender.MultiSkins[1] = Texture'Cyclop2';
			Sender.MultiSkins[2] = Texture'Cyclop3';
			Sender.MultiSkins[3] = Texture'Cyclop4';
			Sender.PlayerReplicationInfo.TalkTexture = Texture'Cyclop5';
			}
		else if (US_PRI(Sender.PlayerReplicationInfo).PlayerModel == "Ninja")
			{
			Sender.MultiSkins[0] = Texture'Ninja1';
			Sender.MultiSkins[1] = Texture'Ninja2';
			Sender.MultiSkins[2] = Texture'Ninja3';
			Sender.MultiSkins[3] = Texture'Ninja4';
			Sender.PlayerReplicationInfo.TalkTexture = Texture'Ninja5';
			}
		else if (US_PRI(Sender.PlayerReplicationInfo).PlayerModel == "Gordon")
			{
			Sender.MultiSkins[0] = Texture'Gordon1';
			Sender.MultiSkins[1] = Texture'Gordon2';
			Sender.MultiSkins[2] = Texture'Gordon3';
			Sender.MultiSkins[3] = Texture'Gordon4';
			Sender.PlayerReplicationInfo.TalkTexture = Texture'Gordon5';
			}
		US_PRI(Sender.PlayerReplicationInfo).bGrabStats = True;
		Level.Game.AddDefaultInventory(Sender);
		}
	else if ( Right(MutateString,8) ~= "UseStats" && US_PRI(Sender.PlayerReplicationInfo).bChoseCharacter == False )
		{
		if (US_PRI(Sender.PlayerReplicationInfo).StatPoints == 0)
			{
			Sender.PlaySound (Sound'UnrealShare.General.BreakGlass',,2.0);
			US_PRI(Sender.PlayerReplicationInfo).bStats = False;
			}
		else if (US_PRI(Sender.PlayerReplicationInfo).bStats)
			{
			Sender.PlaySound (Sound'Umenu.WindowClose',,2.0);
			US_PRI(Sender.PlayerReplicationInfo).bStats = False;
			}
		else
			{
			Sender.PlaySound (Sound'UMenu.WindowOpen',,2.0);
			US_PRI(Sender.PlayerReplicationInfo).bStats = True;
			}
		}
	else if ( Right(MutateString,10) ~= "NextPlayer" && US_PRI(Sender.PlayerReplicationInfo).bStats == True )
		{
		Sender.PlaySound (Sound'BotPack.flak.Click',,2.0);
		if (US_PRI(Sender.PlayerReplicationInfo).CurrentSkill == "Health")
			{
			US_PRI(Sender.PlayerReplicationInfo).CurrentSkill = "Armor";
			}
		else if (US_PRI(Sender.PlayerReplicationInfo).CurrentSkill == "Armor")
			{
			US_PRI(Sender.PlayerReplicationInfo).CurrentSkill = "Damage";
			}
		else if (US_PRI(Sender.PlayerReplicationInfo).CurrentSkill == "Damage")
			{
			US_PRI(Sender.PlayerReplicationInfo).CurrentSkill = "Health";
			}
		}
	else if ( Right(MutateString,10) ~= "PrevPlayer" && US_PRI(Sender.PlayerReplicationInfo).bStats == True )
		{
		Sender.PlaySound (Sound'BotPack.flak.Click',,2.0);
		if (US_PRI(Sender.PlayerReplicationInfo).CurrentSkill == "Health")
			{
			US_PRI(Sender.PlayerReplicationInfo).CurrentSkill = "Damage";
			}
		else if (US_PRI(Sender.PlayerReplicationInfo).CurrentSkill == "Damage")
			{
			US_PRI(Sender.PlayerReplicationInfo).CurrentSkill = "Armor";
			}
		else if (US_PRI(Sender.PlayerReplicationInfo).CurrentSkill == "Armor")
			{
			US_PRI(Sender.PlayerReplicationInfo).CurrentSkill = "Health";
			}
		}
	else if ( Right(MutateString,12) ~= "SelectPlayer" && US_PRI(Sender.PlayerReplicationInfo).bStats == True && US_PRI(Sender.PlayerReplicationInfo).StatPoints > 0 )
		{
		if (US_PRI(Sender.PlayerReplicationInfo).CurrentSkill == "Health" && US_PRI(Sender.PlayerReplicationInfo).BaseHealth < 500)
			{
			US_PRI(Sender.PlayerReplicationInfo).BaseHealth += 5;
			US_PRI(Sender.PlayerReplicationInfo).StatPoints -= 1;
			Sender.PlaySound (Sound'UMenu.BigSelect',,2.0);
			}
		else if (US_PRI(Sender.PlayerReplicationInfo).CurrentSkill == "Armor" && US_PRI(Sender.PlayerReplicationInfo).BaseArmor < 500)
			{
			US_PRI(Sender.PlayerReplicationInfo).BaseArmor += 5;
			US_PRI(Sender.PlayerReplicationInfo).StatPoints -= 1;
			Sender.PlaySound (Sound'UMenu.BigSelect',,2.0);
			}
		else if (US_PRI(Sender.PlayerReplicationInfo).CurrentSkill == "Damage" && US_PRI(Sender.PlayerReplicationInfo).BaseDamage < 200)
			{
			US_PRI(Sender.PlayerReplicationInfo).BaseDamage += 1;
			US_PRI(Sender.PlayerReplicationInfo).StatPoints -= 1;
			Sender.PlaySound (Sound'UMenu.BigSelect',,2.0);
			}
		else
			{
			if ( US_PRI(Sender.PlayerReplicationInfo).bStats == True )
				US_PRI(Sender.PlayerReplicationInfo).bStats = False;
			else
				Sender.PlaySound (Sound'UnrealShare.General.BreakGlass',,2.0);
			}
		}
	else if ( Right(MutateString,5) ~= "bShop" && US_PRI(Sender.PlayerReplicationInfo).bChoseCharacter == False && US_PRI(Sender.PlayerReplicationInfo).bStats == False)
		{
		if (US_PRI(Sender.PlayerReplicationInfo).Money == 0)
			{
			Sender.PlaySound (Sound'UnrealShare.General.BreakGlass',,2.0);
			US_PRI(Sender.PlayerReplicationInfo).bShop = False;
			}
		else if (US_PRI(Sender.PlayerReplicationInfo).bShop)
			{
			Sender.PlaySound (Sound'Umenu.WindowClose',,2.0);
			US_PRI(Sender.PlayerReplicationInfo).bShop = False;
			}
		else
			{
			Sender.PlaySound (Sound'UMenu.WindowOpen',,2.0);
			US_PRI(Sender.PlayerReplicationInfo).bShop = True;
			}
		}
	else if ( Right(MutateString,10) ~= "NextPlayer" && US_PRI(Sender.PlayerReplicationInfo).bShop == True )
		{
		Sender.PlaySound (Sound'BotPack.flak.Click',,2.0);
		if (US_PRI(Sender.PlayerReplicationInfo).CurrentItem == "Translocator")
			{
			US_PRI(Sender.PlayerReplicationInfo).CurrentItem = "Grapple";
			}
		else if (US_PRI(Sender.PlayerReplicationInfo).CurrentItem == "Grapple")
			{
			US_PRI(Sender.PlayerReplicationInfo).CurrentItem = "AssaultRifle";
			}
		else if (US_PRI(Sender.PlayerReplicationInfo).CurrentItem == "AssaultRifle")
			{
			US_PRI(Sender.PlayerReplicationInfo).CurrentItem = "Enforcer";
			}
		else if (US_PRI(Sender.PlayerReplicationInfo).CurrentItem == "Enforcer")
			{
			US_PRI(Sender.PlayerReplicationInfo).CurrentItem = "DoubleEnforcer";
			}
		else if (US_PRI(Sender.PlayerReplicationInfo).CurrentItem == "DoubleEnforcer")
			{
			US_PRI(Sender.PlayerReplicationInfo).CurrentItem = "SniperRifle";
			}
		else if (US_PRI(Sender.PlayerReplicationInfo).CurrentItem == "SniperRifle")
			{
			US_PRI(Sender.PlayerReplicationInfo).CurrentItem = "ShockRifle";
			}
		else if (US_PRI(Sender.PlayerReplicationInfo).CurrentItem == "ShockRifle")
			{
			US_PRI(Sender.PlayerReplicationInfo).CurrentItem = "BioRifle";
			}
		else if (US_PRI(Sender.PlayerReplicationInfo).CurrentItem == "BioRifle")
			{
			US_PRI(Sender.PlayerReplicationInfo).CurrentItem = "Eightball";
			}
		else if (US_PRI(Sender.PlayerReplicationInfo).CurrentItem == "Eightball")
			{
			US_PRI(Sender.PlayerReplicationInfo).CurrentItem = "FlakCannon";
			}
		else if (US_PRI(Sender.PlayerReplicationInfo).CurrentItem == "FlakCannon")
			{
			US_PRI(Sender.PlayerReplicationInfo).CurrentItem = "Minigun";
			}
		else if (US_PRI(Sender.PlayerReplicationInfo).CurrentItem == "Minigun")
			{
			US_PRI(Sender.PlayerReplicationInfo).CurrentItem = "Pulsegun";
			}
		else if (US_PRI(Sender.PlayerReplicationInfo).CurrentItem == "Pulsegun")
			{
			US_PRI(Sender.PlayerReplicationInfo).CurrentItem = "RazorJack";
			}
		else if (US_PRI(Sender.PlayerReplicationInfo).CurrentItem == "RazorJack")
			{
			US_PRI(Sender.PlayerReplicationInfo).CurrentItem = "Lawgiver";
			}
		else if (US_PRI(Sender.PlayerReplicationInfo).CurrentItem == "Lawgiver")
			{
			US_PRI(Sender.PlayerReplicationInfo).CurrentItem = "DoubleLawgiver";
			}
		else if (US_PRI(Sender.PlayerReplicationInfo).CurrentItem == "DoubleLawgiver")
			{
			US_PRI(Sender.PlayerReplicationInfo).CurrentItem = "Painless";
			}
		else if (US_PRI(Sender.PlayerReplicationInfo).CurrentItem == "Painless")
			{
			US_PRI(Sender.PlayerReplicationInfo).CurrentItem = "TwinLauncher";
			}
		else if (US_PRI(Sender.PlayerReplicationInfo).CurrentItem == "TwinLauncher")
			{
			US_PRI(Sender.PlayerReplicationInfo).CurrentItem = "Uzi";
			}
		else if (US_PRI(Sender.PlayerReplicationInfo).CurrentItem == "Uzi")
			{
			US_PRI(Sender.PlayerReplicationInfo).CurrentItem = "AmmoRegen";
			}
		else if (US_PRI(Sender.PlayerReplicationInfo).CurrentItem == "AmmoRegen")
			{
			US_PRI(Sender.PlayerReplicationInfo).CurrentItem = "HealthRegen";
			}
		else if (US_PRI(Sender.PlayerReplicationInfo).CurrentItem == "HealthRegen")
			{
			US_PRI(Sender.PlayerReplicationInfo).CurrentItem = "ArmorRegen";
			}
		else if (US_PRI(Sender.PlayerReplicationInfo).CurrentItem == "ArmorRegen")
			{
			US_PRI(Sender.PlayerReplicationInfo).CurrentItem = "Translocator";
			}
		}
	else if ( Right(MutateString,10) ~= "PrevPlayer" && US_PRI(Sender.PlayerReplicationInfo).bShop == True )
		{
		Sender.PlaySound (Sound'BotPack.flak.Click',,2.0);
		if (US_PRI(Sender.PlayerReplicationInfo).CurrentItem == "Translocator")
			{
			US_PRI(Sender.PlayerReplicationInfo).CurrentItem = "ArmorRegen";
			}
		else if (US_PRI(Sender.PlayerReplicationInfo).CurrentItem == "ArmorRegen")
			{
			US_PRI(Sender.PlayerReplicationInfo).CurrentItem = "HealthRegen";
			}
		else if (US_PRI(Sender.PlayerReplicationInfo).CurrentItem == "HealthRegen")
			{
			US_PRI(Sender.PlayerReplicationInfo).CurrentItem = "AmmoRegen";
			}
		else if (US_PRI(Sender.PlayerReplicationInfo).CurrentItem == "AmmoRegen")
			{
			US_PRI(Sender.PlayerReplicationInfo).CurrentItem = "Uzi";
			}
		else if (US_PRI(Sender.PlayerReplicationInfo).CurrentItem == "Uzi")
			{
			US_PRI(Sender.PlayerReplicationInfo).CurrentItem = "TwinLauncher";
			}
		else if (US_PRI(Sender.PlayerReplicationInfo).CurrentItem == "TwinLauncher")
			{
			US_PRI(Sender.PlayerReplicationInfo).CurrentItem = "Painless";
			}
		else if (US_PRI(Sender.PlayerReplicationInfo).CurrentItem == "Painless")
			{
			US_PRI(Sender.PlayerReplicationInfo).CurrentItem = "DoubleLawgiver";
			}
		else if (US_PRI(Sender.PlayerReplicationInfo).CurrentItem == "DoubleLawgiver")
			{
			US_PRI(Sender.PlayerReplicationInfo).CurrentItem = "Lawgiver";
			}
		else if (US_PRI(Sender.PlayerReplicationInfo).CurrentItem == "Lawgiver")
			{
			US_PRI(Sender.PlayerReplicationInfo).CurrentItem = "RazorJack";
			}
		else if (US_PRI(Sender.PlayerReplicationInfo).CurrentItem == "RazorJack")
			{
			US_PRI(Sender.PlayerReplicationInfo).CurrentItem = "Pulsegun";
			}
		else if (US_PRI(Sender.PlayerReplicationInfo).CurrentItem == "Pulsegun")
			{
			US_PRI(Sender.PlayerReplicationInfo).CurrentItem = "Minigun";
			}
		else if (US_PRI(Sender.PlayerReplicationInfo).CurrentItem == "Minigun")
			{
			US_PRI(Sender.PlayerReplicationInfo).CurrentItem = "FlakCannon";
			}
		else if (US_PRI(Sender.PlayerReplicationInfo).CurrentItem == "FlakCannon")
			{
			US_PRI(Sender.PlayerReplicationInfo).CurrentItem = "Eightball";
			}
		else if (US_PRI(Sender.PlayerReplicationInfo).CurrentItem == "Eightball")
			{
			US_PRI(Sender.PlayerReplicationInfo).CurrentItem = "BioRifle";
			}
		else if (US_PRI(Sender.PlayerReplicationInfo).CurrentItem == "BioRifle")
			{
			US_PRI(Sender.PlayerReplicationInfo).CurrentItem = "ShockRifle";
			}
		else if (US_PRI(Sender.PlayerReplicationInfo).CurrentItem == "ShockRifle")
			{
			US_PRI(Sender.PlayerReplicationInfo).CurrentItem = "SniperRifle";
			}
		else if (US_PRI(Sender.PlayerReplicationInfo).CurrentItem == "SniperRifle")
			{
			US_PRI(Sender.PlayerReplicationInfo).CurrentItem = "DoubleEnforcer";
			}
		else if (US_PRI(Sender.PlayerReplicationInfo).CurrentItem == "DoubleEnforcer")
			{
			US_PRI(Sender.PlayerReplicationInfo).CurrentItem = "Enforcer";
			}
		else if (US_PRI(Sender.PlayerReplicationInfo).CurrentItem == "Enforcer")
			{
			US_PRI(Sender.PlayerReplicationInfo).CurrentItem = "AssaultRifle";
			}
		else if (US_PRI(Sender.PlayerReplicationInfo).CurrentItem == "AssaultRifle")
			{
			US_PRI(Sender.PlayerReplicationInfo).CurrentItem = "Grapple";
			}
		else if (US_PRI(Sender.PlayerReplicationInfo).CurrentItem == "Grapple")
			{
			US_PRI(Sender.PlayerReplicationInfo).CurrentItem = "Translocator";
			}
		}
	else if ( Right(MutateString,12) ~= "SelectPlayer" && US_PRI(Sender.PlayerReplicationInfo).bShop == True )
		{
		if (US_PRI(Sender.PlayerReplicationInfo).CurrentItem == "Translocator" && US_PRI(Sender.PlayerReplicationInfo).Money >= 100 && US_PRI(Sender.PlayerReplicationInfo).Item1 != "Translocator" && US_PRI(Sender.PlayerReplicationInfo).Item2 != "Translocator" && US_PRI(Sender.PlayerReplicationInfo).Item3 != "Translocator")
			{
			if ( US_PRI(Sender.PlayerReplicationInfo).Item1 == "Empty." )
				{
				US_PRI(Sender.PlayerReplicationInfo).Item1 = "Translocator";
				US_PRI(Sender.PlayerReplicationInfo).Money -= 100;
				US_PRI(Sender.PlayerReplicationInfo).bJustPurchased = True;
				DeathMatchPlus(Level.Game).GiveWeapon(Sender,"UniversalSoldiers.USW_Translocator");
				Sender.PlaySound (Sound'UMenu.BigSelect',,2.0);
				}
			else if ( US_PRI(Sender.PlayerReplicationInfo).Item2 == "Empty." )
				{
				US_PRI(Sender.PlayerReplicationInfo).Item2 = "Translocator";
				US_PRI(Sender.PlayerReplicationInfo).Money -= 100;
				US_PRI(Sender.PlayerReplicationInfo).bJustPurchased = True;
				DeathMatchPlus(Level.Game).GiveWeapon(Sender,"UniversalSoldiers.USW_Translocator");
				Sender.PlaySound (Sound'UMenu.BigSelect',,2.0);
				}
			else if ( US_PRI(Sender.PlayerReplicationInfo).Item3 == "Empty." )
				{
				US_PRI(Sender.PlayerReplicationInfo).Item3 = "Translocator";
				US_PRI(Sender.PlayerReplicationInfo).Money -= 100;
				US_PRI(Sender.PlayerReplicationInfo).bJustPurchased = True;
				DeathMatchPlus(Level.Game).GiveWeapon(Sender,"UniversalSoldiers.USW_Translocator");
				Sender.PlaySound (Sound'UMenu.BigSelect',,2.0);
				}
			else
				{
				Sender.PlaySound (Sound'UnrealShare.General.BreakGlass',,2.0);
				}
			}
		else if (US_PRI(Sender.PlayerReplicationInfo).CurrentItem == "Grapple" && US_PRI(Sender.PlayerReplicationInfo).Money >= 100 && US_PRI(Sender.PlayerReplicationInfo).Item1 != "Grapple" && US_PRI(Sender.PlayerReplicationInfo).Item2 != "Grapple" && US_PRI(Sender.PlayerReplicationInfo).Item3 != "Grapple")
			{
			if ( US_PRI(Sender.PlayerReplicationInfo).Item1 == "Empty." )
				{
				US_PRI(Sender.PlayerReplicationInfo).Item1 = "Grapple";
				US_PRI(Sender.PlayerReplicationInfo).Money -= 100;
				US_PRI(Sender.PlayerReplicationInfo).bJustPurchased = True;
				DeathMatchPlus(Level.Game).GiveWeapon(Sender,"UniversalSoldiers.USW_GrappleHook");
				Sender.PlaySound (Sound'UMenu.BigSelect',,2.0);
				}
			else if ( US_PRI(Sender.PlayerReplicationInfo).Item2 == "Empty." )
				{
				US_PRI(Sender.PlayerReplicationInfo).Item2 = "Grapple";
				US_PRI(Sender.PlayerReplicationInfo).Money -= 100;
				US_PRI(Sender.PlayerReplicationInfo).bJustPurchased = True;
				DeathMatchPlus(Level.Game).GiveWeapon(Sender,"UniversalSoldiers.USW_GrappleHook");
				Sender.PlaySound (Sound'UMenu.BigSelect',,2.0);
				}
			else if ( US_PRI(Sender.PlayerReplicationInfo).Item3 == "Empty." )
				{
				US_PRI(Sender.PlayerReplicationInfo).Item3 = "Grapple";
				US_PRI(Sender.PlayerReplicationInfo).Money -= 100;
				US_PRI(Sender.PlayerReplicationInfo).bJustPurchased = True;
				DeathMatchPlus(Level.Game).GiveWeapon(Sender,"UniversalSoldiers.USW_GrappleHook");
				Sender.PlaySound (Sound'UMenu.BigSelect',,2.0);
				}
			else
				{
				Sender.PlaySound (Sound'UnrealShare.General.BreakGlass',,2.0);
				}
			}
		else if (US_PRI(Sender.PlayerReplicationInfo).CurrentItem == "AssaultRifle" && US_PRI(Sender.PlayerReplicationInfo).Money >= 500 && US_PRI(Sender.PlayerReplicationInfo).Item1 != "AssaultRifle" && US_PRI(Sender.PlayerReplicationInfo).Item2 != "AssaultRifle" && US_PRI(Sender.PlayerReplicationInfo).Item3 != "AssaultRifle")
			{
			if ( US_PRI(Sender.PlayerReplicationInfo).Item1 == "Empty." )
				{
				US_PRI(Sender.PlayerReplicationInfo).Item1 = "AssaultRifle";
				US_PRI(Sender.PlayerReplicationInfo).Money -= 500;
				US_PRI(Sender.PlayerReplicationInfo).bJustPurchased = True;
				DeathMatchPlus(Level.Game).GiveWeapon(Sender,"UniversalSoldiers.USW_AssaultRifle");
				Sender.PlaySound (Sound'UMenu.BigSelect',,2.0);
				}
			else if ( US_PRI(Sender.PlayerReplicationInfo).Item2 == "Empty." )
				{
				US_PRI(Sender.PlayerReplicationInfo).Item2 = "AssaultRifle";
				US_PRI(Sender.PlayerReplicationInfo).Money -= 500;
				US_PRI(Sender.PlayerReplicationInfo).bJustPurchased = True;
				DeathMatchPlus(Level.Game).GiveWeapon(Sender,"UniversalSoldiers.USW_AssaultRifle");
				Sender.PlaySound (Sound'UMenu.BigSelect',,2.0);
				}
			else if ( US_PRI(Sender.PlayerReplicationInfo).Item3 == "Empty." )
				{
				US_PRI(Sender.PlayerReplicationInfo).Item3 = "AssaultRifle";
				US_PRI(Sender.PlayerReplicationInfo).Money -= 500;
				US_PRI(Sender.PlayerReplicationInfo).bJustPurchased = True;
				DeathMatchPlus(Level.Game).GiveWeapon(Sender,"UniversalSoldiers.USW_AssaultRifle");
				Sender.PlaySound (Sound'UMenu.BigSelect',,2.0);
				}
			else
				{
				Sender.PlaySound (Sound'UnrealShare.General.BreakGlass',,2.0);
				}
			}
		else if (US_PRI(Sender.PlayerReplicationInfo).CurrentItem == "SniperRifle" && US_PRI(Sender.PlayerReplicationInfo).PlayerModel != "Hitman" && US_PRI(Sender.PlayerReplicationInfo).Money >= 300 && US_PRI(Sender.PlayerReplicationInfo).Item1 != "SniperRifle" && US_PRI(Sender.PlayerReplicationInfo).Item2 != "SniperRifle" && US_PRI(Sender.PlayerReplicationInfo).Item3 != "SniperRifle")
			{
			if ( US_PRI(Sender.PlayerReplicationInfo).Item1 == "Empty." )
				{
				US_PRI(Sender.PlayerReplicationInfo).Item1 = "SniperRifle";
				US_PRI(Sender.PlayerReplicationInfo).Money -= 300;
				US_PRI(Sender.PlayerReplicationInfo).bJustPurchased = True;
				DeathMatchPlus(Level.Game).GiveWeapon(Sender,"UniversalSoldiers.USW_SniperRifle");
				Sender.PlaySound (Sound'UMenu.BigSelect',,2.0);
				}
			else if ( US_PRI(Sender.PlayerReplicationInfo).Item2 == "Empty." )
				{
				US_PRI(Sender.PlayerReplicationInfo).Item2 = "SniperRifle";
				US_PRI(Sender.PlayerReplicationInfo).Money -= 300;
				US_PRI(Sender.PlayerReplicationInfo).bJustPurchased = True;
				DeathMatchPlus(Level.Game).GiveWeapon(Sender,"UniversalSoldiers.USW_SniperRifle");
				Sender.PlaySound (Sound'UMenu.BigSelect',,2.0);
				}
			else if ( US_PRI(Sender.PlayerReplicationInfo).Item3 == "Empty." )
				{
				US_PRI(Sender.PlayerReplicationInfo).Item3 = "SniperRifle";
				US_PRI(Sender.PlayerReplicationInfo).Money -= 300;
				US_PRI(Sender.PlayerReplicationInfo).bJustPurchased = True;
				DeathMatchPlus(Level.Game).GiveWeapon(Sender,"UniversalSoldiers.USW_SniperRifle");
				Sender.PlaySound (Sound'UMenu.BigSelect',,2.0);
				}
			else
				{
				Sender.PlaySound (Sound'UnrealShare.General.BreakGlass',,2.0);
				}
			}
		else if (US_PRI(Sender.PlayerReplicationInfo).CurrentItem == "ShockRifle" && US_PRI(Sender.PlayerReplicationInfo).PlayerModel != "Tensor" && US_PRI(Sender.PlayerReplicationInfo).PlayerModel != "Freezy" && US_PRI(Sender.PlayerReplicationInfo).Money >= 300 && US_PRI(Sender.PlayerReplicationInfo).Item1 != "ShockRifle" && US_PRI(Sender.PlayerReplicationInfo).Item2 != "ShockRifle" && US_PRI(Sender.PlayerReplicationInfo).Item3 != "ShockRifle")
			{
			if ( US_PRI(Sender.PlayerReplicationInfo).Item1 == "Empty." )
				{
				US_PRI(Sender.PlayerReplicationInfo).Item1 = "ShockRifle";
				US_PRI(Sender.PlayerReplicationInfo).Money -= 300;
				US_PRI(Sender.PlayerReplicationInfo).bJustPurchased = True;
				DeathMatchPlus(Level.Game).GiveWeapon(Sender,"UniversalSoldiers.USW_ShockRifle");
				Sender.PlaySound (Sound'UMenu.BigSelect',,2.0);
				}
			else if ( US_PRI(Sender.PlayerReplicationInfo).Item2 == "Empty." )
				{
				US_PRI(Sender.PlayerReplicationInfo).Item2 = "ShockRifle";
				US_PRI(Sender.PlayerReplicationInfo).Money -= 300;
				US_PRI(Sender.PlayerReplicationInfo).bJustPurchased = True;
				DeathMatchPlus(Level.Game).GiveWeapon(Sender,"UniversalSoldiers.USW_ShockRifle");
				Sender.PlaySound (Sound'UMenu.BigSelect',,2.0);
				}
			else if ( US_PRI(Sender.PlayerReplicationInfo).Item3 == "Empty." )
				{
				US_PRI(Sender.PlayerReplicationInfo).Item3 = "ShockRifle";
				US_PRI(Sender.PlayerReplicationInfo).Money -= 300;
				US_PRI(Sender.PlayerReplicationInfo).bJustPurchased = True;
				DeathMatchPlus(Level.Game).GiveWeapon(Sender,"UniversalSoldiers.USW_ShockRifle");
				Sender.PlaySound (Sound'UMenu.BigSelect',,2.0);
				}
			else
				{
				Sender.PlaySound (Sound'UnrealShare.General.BreakGlass',,2.0);
				}
			}
		else if (US_PRI(Sender.PlayerReplicationInfo).CurrentItem == "Enforcer" && US_PRI(Sender.PlayerReplicationInfo).PlayerModel != "Cyborg" && US_PRI(Sender.PlayerReplicationInfo).Money >= 150 && US_PRI(Sender.PlayerReplicationInfo).Item1 != "Enforcer" && US_PRI(Sender.PlayerReplicationInfo).Item2 != "Enforcer" && US_PRI(Sender.PlayerReplicationInfo).Item3 != "Enforcer")
			{
			if ( US_PRI(Sender.PlayerReplicationInfo).Item1 == "Empty." )
				{
				US_PRI(Sender.PlayerReplicationInfo).Item1 = "Enforcer";
				US_PRI(Sender.PlayerReplicationInfo).Money -= 150;
				US_PRI(Sender.PlayerReplicationInfo).bJustPurchased = True;
				DeathMatchPlus(Level.Game).GiveWeapon(Sender,"UniversalSoldiers.USW_Enforcer");
				Sender.PlaySound (Sound'UMenu.BigSelect',,2.0);
				}
			else if ( US_PRI(Sender.PlayerReplicationInfo).Item2 == "Empty." )
				{
				US_PRI(Sender.PlayerReplicationInfo).Item2 = "Enforcer";
				US_PRI(Sender.PlayerReplicationInfo).Money -= 150;
				US_PRI(Sender.PlayerReplicationInfo).bJustPurchased = True;
				DeathMatchPlus(Level.Game).GiveWeapon(Sender,"UniversalSoldiers.USW_Enforcer");
				Sender.PlaySound (Sound'UMenu.BigSelect',,2.0);
				}
			else if ( US_PRI(Sender.PlayerReplicationInfo).Item3 == "Empty." )
				{
				US_PRI(Sender.PlayerReplicationInfo).Item3 = "Enforcer";
				US_PRI(Sender.PlayerReplicationInfo).Money -= 150;
				US_PRI(Sender.PlayerReplicationInfo).bJustPurchased = True;
				DeathMatchPlus(Level.Game).GiveWeapon(Sender,"UniversalSoldiers.USW_Enforcer");
				Sender.PlaySound (Sound'UMenu.BigSelect',,2.0);
				}
			else
				{
				Sender.PlaySound (Sound'UnrealShare.General.BreakGlass',,2.0);
				}
			}
		else if (US_PRI(Sender.PlayerReplicationInfo).CurrentItem == "DoubleEnforcer" && US_PRI(Sender.PlayerReplicationInfo).Money >= 150 && US_PRI(Sender.PlayerReplicationInfo).Item1 != "DoubleEnforcer" && US_PRI(Sender.PlayerReplicationInfo).Item2 != "DoubleEnforcer" && US_PRI(Sender.PlayerReplicationInfo).Item3 != "DoubleEnforcer")
			{
			if ( US_PRI(Sender.PlayerReplicationInfo).Item1 == "Empty." )
				{
				US_PRI(Sender.PlayerReplicationInfo).Item1 = "DoubleEnforcer";
				US_PRI(Sender.PlayerReplicationInfo).Money -= 150;
				US_PRI(Sender.PlayerReplicationInfo).bJustPurchased = True;
				Inv = Spawn(class'USW_Enforcer');
				if ( USW_Enforcer(Inv) != None )
					{
					Sender.Inventory.HandlePickupQuery( Inv );
					}
				Inv.Destroy();
				Sender.PlaySound (Sound'UMenu.BigSelect',,2.0);
				}
			else if ( US_PRI(Sender.PlayerReplicationInfo).Item2 == "Empty." )
				{
				US_PRI(Sender.PlayerReplicationInfo).Item2 = "DoubleEnforcer";
				US_PRI(Sender.PlayerReplicationInfo).Money -= 150;
				US_PRI(Sender.PlayerReplicationInfo).bJustPurchased = True;
				Inv = Spawn(class'USW_Enforcer');
				if ( USW_Enforcer(Inv) != None )
					{
					Sender.Inventory.HandlePickupQuery( Inv );
					}
				Inv.Destroy();
				Sender.PlaySound (Sound'UMenu.BigSelect',,2.0);
				}
			else if ( US_PRI(Sender.PlayerReplicationInfo).Item3 == "Empty." )
				{
				US_PRI(Sender.PlayerReplicationInfo).Item3 = "DoubleEnforcer";
				US_PRI(Sender.PlayerReplicationInfo).Money -= 150;
				US_PRI(Sender.PlayerReplicationInfo).bJustPurchased = True;
				//Spawn(class'USW_Enforcer',,,Sender.Location);
				Inv = Spawn(class'USW_Enforcer');
				if ( USW_Enforcer(Inv) != None )
					{
					Sender.Inventory.HandlePickupQuery( Inv );
					}
				Inv.Destroy();
				Sender.PlaySound (Sound'UMenu.BigSelect',,2.0);
				}
			else
				{
				Sender.PlaySound (Sound'UnrealShare.General.BreakGlass',,2.0);
				}
			}
		else if (US_PRI(Sender.PlayerReplicationInfo).CurrentItem == "BioRifle" && US_PRI(Sender.PlayerReplicationInfo).PlayerModel != "Ninja" && US_PRI(Sender.PlayerReplicationInfo).Money >= 300 && US_PRI(Sender.PlayerReplicationInfo).Item1 != "BioRifle" && US_PRI(Sender.PlayerReplicationInfo).Item2 != "BioRifle" && US_PRI(Sender.PlayerReplicationInfo).Item3 != "BioRifle")
			{
			if ( US_PRI(Sender.PlayerReplicationInfo).Item1 == "Empty." )
				{
				US_PRI(Sender.PlayerReplicationInfo).Item1 = "BioRifle";
				US_PRI(Sender.PlayerReplicationInfo).Money -= 300;
				US_PRI(Sender.PlayerReplicationInfo).bJustPurchased = True;
				DeathMatchPlus(Level.Game).GiveWeapon(Sender,"UniversalSoldiers.USW_BioRifle");
				Sender.PlaySound (Sound'UMenu.BigSelect',,2.0);
				}
			else if ( US_PRI(Sender.PlayerReplicationInfo).Item2 == "Empty." )
				{
				US_PRI(Sender.PlayerReplicationInfo).Item2 = "BioRifle";
				US_PRI(Sender.PlayerReplicationInfo).Money -= 300;
				US_PRI(Sender.PlayerReplicationInfo).bJustPurchased = True;
				DeathMatchPlus(Level.Game).GiveWeapon(Sender,"UniversalSoldiers.USW_BioRifle");
				Sender.PlaySound (Sound'UMenu.BigSelect',,2.0);
				}
			else if ( US_PRI(Sender.PlayerReplicationInfo).Item3 == "Empty." )
				{
				US_PRI(Sender.PlayerReplicationInfo).Item3 = "BioRifle";
				US_PRI(Sender.PlayerReplicationInfo).Money -= 300;
				US_PRI(Sender.PlayerReplicationInfo).bJustPurchased = True;
				DeathMatchPlus(Level.Game).GiveWeapon(Sender,"UniversalSoldiers.USW_BioRifle");
				Sender.PlaySound (Sound'UMenu.BigSelect',,2.0);
				}
			else
				{
				Sender.PlaySound (Sound'UnrealShare.General.BreakGlass',,2.0);
				}
			}
		else if (US_PRI(Sender.PlayerReplicationInfo).CurrentItem == "Eightball" && US_PRI(Sender.PlayerReplicationInfo).PlayerModel != "Cyclop" && US_PRI(Sender.PlayerReplicationInfo).Money >= 350 && US_PRI(Sender.PlayerReplicationInfo).Item1 != "Eightball" && US_PRI(Sender.PlayerReplicationInfo).Item2 != "Eightball" && US_PRI(Sender.PlayerReplicationInfo).Item3 != "Eightball")
			{
			if ( US_PRI(Sender.PlayerReplicationInfo).Item1 == "Empty." )
				{
				US_PRI(Sender.PlayerReplicationInfo).Item1 = "Eightball";
				US_PRI(Sender.PlayerReplicationInfo).Money -= 350;
				US_PRI(Sender.PlayerReplicationInfo).bJustPurchased = True;
				DeathMatchPlus(Level.Game).GiveWeapon(Sender,"UniversalSoldiers.USW_Eightball");
				Sender.PlaySound (Sound'UMenu.BigSelect',,2.0);
				}
			else if ( US_PRI(Sender.PlayerReplicationInfo).Item2 == "Empty." )
				{
				US_PRI(Sender.PlayerReplicationInfo).Item2 = "Eightball";
				US_PRI(Sender.PlayerReplicationInfo).Money -= 350;
				US_PRI(Sender.PlayerReplicationInfo).bJustPurchased = True;
				DeathMatchPlus(Level.Game).GiveWeapon(Sender,"UniversalSoldiers.USW_Eightball");
				Sender.PlaySound (Sound'UMenu.BigSelect',,2.0);
				}
			else if ( US_PRI(Sender.PlayerReplicationInfo).Item3 == "Empty." )
				{
				US_PRI(Sender.PlayerReplicationInfo).Item3 = "Eightball";
				US_PRI(Sender.PlayerReplicationInfo).Money -= 350;
				US_PRI(Sender.PlayerReplicationInfo).bJustPurchased = True;
				DeathMatchPlus(Level.Game).GiveWeapon(Sender,"UniversalSoldiers.USW_Eightball");
				Sender.PlaySound (Sound'UMenu.BigSelect',,2.0);
				}
			else
				{
				Sender.PlaySound (Sound'UnrealShare.General.BreakGlass',,2.0);
				}
			}
		else if (US_PRI(Sender.PlayerReplicationInfo).CurrentItem == "FlakCannon" && US_PRI(Sender.PlayerReplicationInfo).PlayerModel != "Trooper" && US_PRI(Sender.PlayerReplicationInfo).Money >= 350 && US_PRI(Sender.PlayerReplicationInfo).Item1 != "FlakCannon" && US_PRI(Sender.PlayerReplicationInfo).Item2 != "FlakCannon" && US_PRI(Sender.PlayerReplicationInfo).Item3 != "FlakCannon")
			{
			if ( US_PRI(Sender.PlayerReplicationInfo).Item1 == "Empty." )
				{
				US_PRI(Sender.PlayerReplicationInfo).Item1 = "FlakCannon";
				US_PRI(Sender.PlayerReplicationInfo).Money -= 350;
				US_PRI(Sender.PlayerReplicationInfo).bJustPurchased = True;
				DeathMatchPlus(Level.Game).GiveWeapon(Sender,"UniversalSoldiers.USW_FlakCannon");
				Sender.PlaySound (Sound'UMenu.BigSelect',,2.0);
				}
			else if ( US_PRI(Sender.PlayerReplicationInfo).Item2 == "Empty." )
				{
				US_PRI(Sender.PlayerReplicationInfo).Item2 = "FlakCannon";
				US_PRI(Sender.PlayerReplicationInfo).Money -= 350;
				US_PRI(Sender.PlayerReplicationInfo).bJustPurchased = True;
				DeathMatchPlus(Level.Game).GiveWeapon(Sender,"UniversalSoldiers.USW_FlakCannon");
				Sender.PlaySound (Sound'UMenu.BigSelect',,2.0);
				}
			else if ( US_PRI(Sender.PlayerReplicationInfo).Item3 == "Empty." )
				{
				US_PRI(Sender.PlayerReplicationInfo).Item3 = "FlakCannon";
				US_PRI(Sender.PlayerReplicationInfo).Money -= 350;
				US_PRI(Sender.PlayerReplicationInfo).bJustPurchased = True;
				DeathMatchPlus(Level.Game).GiveWeapon(Sender,"UniversalSoldiers.USW_FlakCannon");
				Sender.PlaySound (Sound'UMenu.BigSelect',,2.0);
				}
			else
				{
				Sender.PlaySound (Sound'UnrealShare.General.BreakGlass',,2.0);
				}
			}
		else if (US_PRI(Sender.PlayerReplicationInfo).CurrentItem == "Minigun" && US_PRI(Sender.PlayerReplicationInfo).PlayerModel != "Snake" && US_PRI(Sender.PlayerReplicationInfo).Money >= 300 && US_PRI(Sender.PlayerReplicationInfo).Item1 != "Minigun" && US_PRI(Sender.PlayerReplicationInfo).Item2 != "Minigun" && US_PRI(Sender.PlayerReplicationInfo).Item3 != "Minigun")
			{
			if ( US_PRI(Sender.PlayerReplicationInfo).Item1 == "Empty." )
				{
				US_PRI(Sender.PlayerReplicationInfo).Item1 = "Minigun";
				US_PRI(Sender.PlayerReplicationInfo).Money -= 300;
				US_PRI(Sender.PlayerReplicationInfo).bJustPurchased = True;
				DeathMatchPlus(Level.Game).GiveWeapon(Sender,"UniversalSoldiers.USW_Minigun");
				Sender.PlaySound (Sound'UMenu.BigSelect',,2.0);
				}
			else if ( US_PRI(Sender.PlayerReplicationInfo).Item2 == "Empty." )
				{
				US_PRI(Sender.PlayerReplicationInfo).Item2 = "Minigun";
				US_PRI(Sender.PlayerReplicationInfo).Money -= 300;
				US_PRI(Sender.PlayerReplicationInfo).bJustPurchased = True;
				DeathMatchPlus(Level.Game).GiveWeapon(Sender,"UniversalSoldiers.USW_Minigun");
				Sender.PlaySound (Sound'UMenu.BigSelect',,2.0);
				}
			else if ( US_PRI(Sender.PlayerReplicationInfo).Item3 == "Empty." )
				{
				US_PRI(Sender.PlayerReplicationInfo).Item3 = "Minigun";
				US_PRI(Sender.PlayerReplicationInfo).Money -= 300;
				US_PRI(Sender.PlayerReplicationInfo).bJustPurchased = True;
				DeathMatchPlus(Level.Game).GiveWeapon(Sender,"UniversalSoldiers.USW_Minigun");
				Sender.PlaySound (Sound'UMenu.BigSelect',,2.0);
				}
			else
				{
				Sender.PlaySound (Sound'UnrealShare.General.BreakGlass',,2.0);
				}
			}
		else if (US_PRI(Sender.PlayerReplicationInfo).CurrentItem == "Pulsegun" && US_PRI(Sender.PlayerReplicationInfo).PlayerModel != "Gordon" && US_PRI(Sender.PlayerReplicationInfo).Money >= 300 && US_PRI(Sender.PlayerReplicationInfo).Item1 != "Pulsegun" && US_PRI(Sender.PlayerReplicationInfo).Item2 != "Pulsegun" && US_PRI(Sender.PlayerReplicationInfo).Item3 != "Pulsegun")
			{
			if ( US_PRI(Sender.PlayerReplicationInfo).Item1 == "Empty." )
				{
				US_PRI(Sender.PlayerReplicationInfo).Item1 = "Pulsegun";
				US_PRI(Sender.PlayerReplicationInfo).Money -= 300;
				US_PRI(Sender.PlayerReplicationInfo).bJustPurchased = True;
				DeathMatchPlus(Level.Game).GiveWeapon(Sender,"UniversalSoldiers.USW_Pulsegun");
				Sender.PlaySound (Sound'UMenu.BigSelect',,2.0);
				}
			else if ( US_PRI(Sender.PlayerReplicationInfo).Item2 == "Empty." )
				{
				US_PRI(Sender.PlayerReplicationInfo).Item2 = "Pulsegun";
				US_PRI(Sender.PlayerReplicationInfo).Money -= 300;
				US_PRI(Sender.PlayerReplicationInfo).bJustPurchased = True;
				DeathMatchPlus(Level.Game).GiveWeapon(Sender,"UniversalSoldiers.USW_Pulsegun");
				Sender.PlaySound (Sound'UMenu.BigSelect',,2.0);
				}
			else if ( US_PRI(Sender.PlayerReplicationInfo).Item3 == "Empty." )
				{
				US_PRI(Sender.PlayerReplicationInfo).Item3 = "Pulsegun";
				US_PRI(Sender.PlayerReplicationInfo).Money -= 300;
				US_PRI(Sender.PlayerReplicationInfo).bJustPurchased = True;
				DeathMatchPlus(Level.Game).GiveWeapon(Sender,"UniversalSoldiers.USW_Pulsegun");
				Sender.PlaySound (Sound'UMenu.BigSelect',,2.0);
				}
			else
				{
				Sender.PlaySound (Sound'UnrealShare.General.BreakGlass',,2.0);
				}
			}
		else if (US_PRI(Sender.PlayerReplicationInfo).CurrentItem == "RazorJack" && US_PRI(Sender.PlayerReplicationInfo).PlayerModel != "Vampire" && US_PRI(Sender.PlayerReplicationInfo).Money >= 300 && US_PRI(Sender.PlayerReplicationInfo).Item1 != "RazorJack" && US_PRI(Sender.PlayerReplicationInfo).Item2 != "RazorJack" && US_PRI(Sender.PlayerReplicationInfo).Item3 != "RazorJack")
			{
			if ( US_PRI(Sender.PlayerReplicationInfo).Item1 == "Empty." )
				{
				US_PRI(Sender.PlayerReplicationInfo).Item1 = "RazorJack";
				US_PRI(Sender.PlayerReplicationInfo).Money -= 300;
				US_PRI(Sender.PlayerReplicationInfo).bJustPurchased = True;
				DeathMatchPlus(Level.Game).GiveWeapon(Sender,"UniversalSoldiers.USW_RazorJack");
				Sender.PlaySound (Sound'UMenu.BigSelect',,2.0);
				}
			else if ( US_PRI(Sender.PlayerReplicationInfo).Item2 == "Empty." )
				{
				US_PRI(Sender.PlayerReplicationInfo).Item2 = "RazorJack";
				US_PRI(Sender.PlayerReplicationInfo).Money -= 300;
				US_PRI(Sender.PlayerReplicationInfo).bJustPurchased = True;
				DeathMatchPlus(Level.Game).GiveWeapon(Sender,"UniversalSoldiers.USW_RazorJack");
				Sender.PlaySound (Sound'UMenu.BigSelect',,2.0);
				}
			else if ( US_PRI(Sender.PlayerReplicationInfo).Item3 == "Empty." )
				{
				US_PRI(Sender.PlayerReplicationInfo).Item3 = "RazorJack";
				US_PRI(Sender.PlayerReplicationInfo).Money -= 300;
				US_PRI(Sender.PlayerReplicationInfo).bJustPurchased = True;
				DeathMatchPlus(Level.Game).GiveWeapon(Sender,"UniversalSoldiers.USW_RazorJack");
				Sender.PlaySound (Sound'UMenu.BigSelect',,2.0);
				}
			else
				{
				Sender.PlaySound (Sound'UnrealShare.General.BreakGlass',,2.0);
				}
			}
		else if (US_PRI(Sender.PlayerReplicationInfo).CurrentItem == "Lawgiver" && US_PRI(Sender.PlayerReplicationInfo).Money >= 300 && US_PRI(Sender.PlayerReplicationInfo).Item1 != "Lawgiver" && US_PRI(Sender.PlayerReplicationInfo).Item2 != "Lawgiver" && US_PRI(Sender.PlayerReplicationInfo).Item3 != "Lawgiver")
			{
			if ( US_PRI(Sender.PlayerReplicationInfo).Item1 == "Empty." )
				{
				US_PRI(Sender.PlayerReplicationInfo).Item1 = "Lawgiver";
				US_PRI(Sender.PlayerReplicationInfo).Money -= 400;
				US_PRI(Sender.PlayerReplicationInfo).bJustPurchased = True;
				DeathMatchPlus(Level.Game).GiveWeapon(Sender,"UniversalSoldiers.USW_Lawgiver");
				Sender.PlaySound (Sound'UMenu.BigSelect',,2.0);
				}
			else if ( US_PRI(Sender.PlayerReplicationInfo).Item2 == "Empty." )
				{
				US_PRI(Sender.PlayerReplicationInfo).Item2 = "Lawgiver";
				US_PRI(Sender.PlayerReplicationInfo).Money -= 400;
				US_PRI(Sender.PlayerReplicationInfo).bJustPurchased = True;
				DeathMatchPlus(Level.Game).GiveWeapon(Sender,"UniversalSoldiers.USW_Lawgiver");
				Sender.PlaySound (Sound'UMenu.BigSelect',,2.0);
				}
			else if ( US_PRI(Sender.PlayerReplicationInfo).Item3 == "Empty." )
				{
				US_PRI(Sender.PlayerReplicationInfo).Item3 = "Lawgiver";
				US_PRI(Sender.PlayerReplicationInfo).Money -= 400;
				US_PRI(Sender.PlayerReplicationInfo).bJustPurchased = True;
				DeathMatchPlus(Level.Game).GiveWeapon(Sender,"UniversalSoldiers.USW_Lawgiver");
				Sender.PlaySound (Sound'UMenu.BigSelect',,2.0);
				}
			else
				{
				Sender.PlaySound (Sound'UnrealShare.General.BreakGlass',,2.0);
				}
			}
		else if (US_PRI(Sender.PlayerReplicationInfo).CurrentItem == "DoubleLawgiver" && US_PRI(Sender.PlayerReplicationInfo).Money >= 400 && US_PRI(Sender.PlayerReplicationInfo).Item1 != "DoubleLawgiver" && US_PRI(Sender.PlayerReplicationInfo).Item2 != "DoubleLawgiver" && US_PRI(Sender.PlayerReplicationInfo).Item3 != "DoubleLawgiver")
			{
			if ( US_PRI(Sender.PlayerReplicationInfo).Item1 == "Empty." )
				{
				US_PRI(Sender.PlayerReplicationInfo).Item1 = "DoubleLawgiver";
				US_PRI(Sender.PlayerReplicationInfo).Money -= 400;
				US_PRI(Sender.PlayerReplicationInfo).bJustPurchased = True;
				Inv = Spawn(class'USW_Lawgiver');
				if ( USW_Lawgiver(Inv) != None )
					{
					Sender.Inventory.HandlePickupQuery( Inv );
					}
				Inv.Destroy();
				Sender.PlaySound (Sound'UMenu.BigSelect',,2.0);
				}
			else if ( US_PRI(Sender.PlayerReplicationInfo).Item2 == "Empty." )
				{
				US_PRI(Sender.PlayerReplicationInfo).Item2 = "DoubleLawgiver";
				US_PRI(Sender.PlayerReplicationInfo).Money -= 400;
				US_PRI(Sender.PlayerReplicationInfo).bJustPurchased = True;
				Inv = Spawn(class'USW_Lawgiver');
				if ( USW_Lawgiver(Inv) != None )
					{
					Sender.Inventory.HandlePickupQuery( Inv );
					}
				Inv.Destroy();
				Sender.PlaySound (Sound'UMenu.BigSelect',,2.0);
				}
			else if ( US_PRI(Sender.PlayerReplicationInfo).Item3 == "Empty." )
				{
				US_PRI(Sender.PlayerReplicationInfo).Item3 = "DoubleLawgiver";
				US_PRI(Sender.PlayerReplicationInfo).Money -= 400;
				US_PRI(Sender.PlayerReplicationInfo).bJustPurchased = True;
				//Spawn(class'USW_Enforcer',,,Sender.Location);
				Inv = Spawn(class'USW_Lawgiver');
				if ( USW_Lawgiver(Inv) != None )
					{
					Sender.Inventory.HandlePickupQuery( Inv );
					}
				Inv.Destroy();
				Sender.PlaySound (Sound'UMenu.BigSelect',,2.0);
				}
			else
				{
				Sender.PlaySound (Sound'UnrealShare.General.BreakGlass',,2.0);
				}
			}
		else if (US_PRI(Sender.PlayerReplicationInfo).CurrentItem == "Painless" && US_PRI(Sender.PlayerReplicationInfo).Money >= 600 && US_PRI(Sender.PlayerReplicationInfo).Item1 != "Painless" && US_PRI(Sender.PlayerReplicationInfo).Item2 != "Painless" && US_PRI(Sender.PlayerReplicationInfo).Item3 != "Painless")
			{
			if ( US_PRI(Sender.PlayerReplicationInfo).Item1 == "Empty." )
				{
				US_PRI(Sender.PlayerReplicationInfo).Item1 = "Painless";
				US_PRI(Sender.PlayerReplicationInfo).Money -= 600;
				US_PRI(Sender.PlayerReplicationInfo).bJustPurchased = True;
				DeathMatchPlus(Level.Game).GiveWeapon(Sender,"UniversalSoldiers.USW_Painless");
				Sender.PlaySound (Sound'UMenu.BigSelect',,2.0);
				}
			else if ( US_PRI(Sender.PlayerReplicationInfo).Item2 == "Empty." )
				{
				US_PRI(Sender.PlayerReplicationInfo).Item2 = "Painless";
				US_PRI(Sender.PlayerReplicationInfo).Money -= 600;
				US_PRI(Sender.PlayerReplicationInfo).bJustPurchased = True;
				DeathMatchPlus(Level.Game).GiveWeapon(Sender,"UniversalSoldiers.USW_Painless");
				Sender.PlaySound (Sound'UMenu.BigSelect',,2.0);
				}
			else if ( US_PRI(Sender.PlayerReplicationInfo).Item3 == "Empty." )
				{
				US_PRI(Sender.PlayerReplicationInfo).Item3 = "Painless";
				US_PRI(Sender.PlayerReplicationInfo).Money -= 600;
				US_PRI(Sender.PlayerReplicationInfo).bJustPurchased = True;
				DeathMatchPlus(Level.Game).GiveWeapon(Sender,"UniversalSoldiers.USW_Painless");
				Sender.PlaySound (Sound'UMenu.BigSelect',,2.0);
				}
			else
				{
				Sender.PlaySound (Sound'UnrealShare.General.BreakGlass',,2.0);
				}
			}
		else if (US_PRI(Sender.PlayerReplicationInfo).CurrentItem == "TwinLauncher" && US_PRI(Sender.PlayerReplicationInfo).Money >= 600 && US_PRI(Sender.PlayerReplicationInfo).Item1 != "TwinLauncher" && US_PRI(Sender.PlayerReplicationInfo).Item2 != "TwinLauncher" && US_PRI(Sender.PlayerReplicationInfo).Item3 != "TwinLauncher")
			{
			if ( US_PRI(Sender.PlayerReplicationInfo).Item1 == "Empty." )
				{
				US_PRI(Sender.PlayerReplicationInfo).Item1 = "TwinLauncher";
				US_PRI(Sender.PlayerReplicationInfo).Money -= 600;
				US_PRI(Sender.PlayerReplicationInfo).bJustPurchased = True;
				DeathMatchPlus(Level.Game).GiveWeapon(Sender,"UniversalSoldiers.USW_TwinLauncher");
				Sender.PlaySound (Sound'UMenu.BigSelect',,2.0);
				}
			else if ( US_PRI(Sender.PlayerReplicationInfo).Item2 == "Empty." )
				{
				US_PRI(Sender.PlayerReplicationInfo).Item2 = "TwinLauncher";
				US_PRI(Sender.PlayerReplicationInfo).Money -= 600;
				US_PRI(Sender.PlayerReplicationInfo).bJustPurchased = True;
				DeathMatchPlus(Level.Game).GiveWeapon(Sender,"UniversalSoldiers.USW_TwinLauncher");
				Sender.PlaySound (Sound'UMenu.BigSelect',,2.0);
				}
			else if ( US_PRI(Sender.PlayerReplicationInfo).Item3 == "Empty." )
				{
				US_PRI(Sender.PlayerReplicationInfo).Item3 = "TwinLauncher";
				US_PRI(Sender.PlayerReplicationInfo).Money -= 600;
				US_PRI(Sender.PlayerReplicationInfo).bJustPurchased = True;
				DeathMatchPlus(Level.Game).GiveWeapon(Sender,"UniversalSoldiers.USW_TwinLauncher");
				Sender.PlaySound (Sound'UMenu.BigSelect',,2.0);
				}
			else
				{
				Sender.PlaySound (Sound'UnrealShare.General.BreakGlass',,2.0);
				}
			}
		else if (US_PRI(Sender.PlayerReplicationInfo).CurrentItem == "Uzi" && US_PRI(Sender.PlayerReplicationInfo).Money >= 700 && US_PRI(Sender.PlayerReplicationInfo).Item1 != "Uzi" && US_PRI(Sender.PlayerReplicationInfo).Item2 != "Uzi" && US_PRI(Sender.PlayerReplicationInfo).Item3 != "Uzi")
			{
			if ( US_PRI(Sender.PlayerReplicationInfo).Item1 == "Empty." )
				{
				US_PRI(Sender.PlayerReplicationInfo).Item1 = "Uzi";
				US_PRI(Sender.PlayerReplicationInfo).Money -= 700;
				US_PRI(Sender.PlayerReplicationInfo).bJustPurchased = True;
				DeathMatchPlus(Level.Game).GiveWeapon(Sender,"UniversalSoldiers.USW_Uzi");
				Sender.PlaySound (Sound'UMenu.BigSelect',,2.0);
				}
			else if ( US_PRI(Sender.PlayerReplicationInfo).Item2 == "Empty." )
				{
				US_PRI(Sender.PlayerReplicationInfo).Item2 = "Uzi";
				US_PRI(Sender.PlayerReplicationInfo).Money -= 700;
				US_PRI(Sender.PlayerReplicationInfo).bJustPurchased = True;
				DeathMatchPlus(Level.Game).GiveWeapon(Sender,"UniversalSoldiers.USW_Uzi");
				Sender.PlaySound (Sound'UMenu.BigSelect',,2.0);
				}
			else if ( US_PRI(Sender.PlayerReplicationInfo).Item3 == "Empty." )
				{
				US_PRI(Sender.PlayerReplicationInfo).Item3 = "Uzi";
				US_PRI(Sender.PlayerReplicationInfo).Money -= 700;
				US_PRI(Sender.PlayerReplicationInfo).bJustPurchased = True;
				DeathMatchPlus(Level.Game).GiveWeapon(Sender,"UniversalSoldiers.USW_Uzi");
				Sender.PlaySound (Sound'UMenu.BigSelect',,2.0);
				}
			else
				{
				Sender.PlaySound (Sound'UnrealShare.General.BreakGlass',,2.0);
				}
			}
		else if (US_PRI(Sender.PlayerReplicationInfo).CurrentItem == "AmmoRegen" && !US_PRI(Sender.PlayerReplicationInfo).bHasAmmoRegen && US_PRI(Sender.PlayerReplicationInfo).Money >= 500)
			{
			US_PRI(Sender.PlayerReplicationInfo).bHasAmmoRegen = True;
			US_PRI(Sender.PlayerReplicationInfo).Money -= 500;
			US_PRI(Sender.PlayerReplicationInfo).bJustPurchased = True;
			Sender.PlaySound (Sound'UMenu.BigSelect',,2.0);
			}
		else if (US_PRI(Sender.PlayerReplicationInfo).CurrentItem == "HealthRegen" && !US_PRI(Sender.PlayerReplicationInfo).bHasHealthRegen && US_PRI(Sender.PlayerReplicationInfo).Money >= 500)
			{
			US_PRI(Sender.PlayerReplicationInfo).bHasHealthRegen = True;
			US_PRI(Sender.PlayerReplicationInfo).Money -= 500;
			US_PRI(Sender.PlayerReplicationInfo).bJustPurchased = True;
			Sender.PlaySound (Sound'UMenu.BigSelect',,2.0);
			}
		else if (US_PRI(Sender.PlayerReplicationInfo).CurrentItem == "ArmorRegen" && !US_PRI(Sender.PlayerReplicationInfo).bHasArmorRegen && US_PRI(Sender.PlayerReplicationInfo).Money >= 500)
			{
			US_PRI(Sender.PlayerReplicationInfo).bHasArmorRegen = True;
			US_PRI(Sender.PlayerReplicationInfo).Money -= 500;
			US_PRI(Sender.PlayerReplicationInfo).bJustPurchased = True;
			Sender.PlaySound (Sound'UMenu.BigSelect',,2.0);
			}
		else
			{
			Sender.PlaySound (Sound'UnrealShare.General.BreakGlass',,2.0);
			}
		}
	else if ( Right(MutateString,13) ~= "ViewCharacter" && !US_PRI(Sender.PlayerReplicationInfo).bShop && !US_PRI(Sender.PlayerReplicationInfo).bChoseCharacter )
		{
		if (US_PRI(Sender.PlayerReplicationInfo).bViewCharacter)
			{
			US_PRI(Sender.PlayerReplicationInfo).bViewCharacter = False;
			Sender.PlaySound (Sound'UMenu.WindowClose',,2.0);
			US_PRI(Sender.PlayerReplicationInfo).CurrentItem = "Enforcer";
			}
		else
			{
			US_PRI(Sender.PlayerReplicationInfo).bViewCharacter = True;
			Sender.PlaySound (Sound'UMenu.WindowOpen',,2.0);
			US_PRI(Sender.PlayerReplicationInfo).CurrentItem = "Item1";
			}
		}
	else if ( Right(MutateString,12) ~= "SelectPlayer" && US_PRI(Sender.PlayerReplicationInfo).bViewCharacter )
		{
		if (US_PRI(Sender.PlayerReplicationInfo).CurrentItem == "Item1")
			{
			US_PRI(Sender.PlayerReplicationInfo).Item1 = "Empty.";
			}
		else if (US_PRI(Sender.PlayerReplicationInfo).CurrentItem == "Item2")
			{
			US_PRI(Sender.PlayerReplicationInfo).Item2 = "Empty.";
			}
		else if (US_PRI(Sender.PlayerReplicationInfo).CurrentItem == "Item3")
			{
			US_PRI(Sender.PlayerReplicationInfo).Item3 = "Empty.";
			}
		Sender.PlaySound (Sound'UMenu.BigSelect',,2.0);
		}
	else if ( Right(MutateString,10) ~= "NextPlayer" && US_PRI(Sender.PlayerReplicationInfo).bViewCharacter )
		{
		Sender.PlaySound (Sound'BotPack.flak.Click',,2.0);
		if (US_PRI(Sender.PlayerReplicationInfo).CurrentItem == "Item1")
			{
			US_PRI(Sender.PlayerReplicationInfo).CurrentItem = "Item2";
			}
		else if (US_PRI(Sender.PlayerReplicationInfo).CurrentItem == "Item2")
			{
			US_PRI(Sender.PlayerReplicationInfo).CurrentItem = "Item3";
			}
		else if (US_PRI(Sender.PlayerReplicationInfo).CurrentItem == "Item3")
			{
			US_PRI(Sender.PlayerReplicationInfo).CurrentItem = "Item1";
			}
		}
	else if ( Right(MutateString,10) ~= "PrevPlayer" && US_PRI(Sender.PlayerReplicationInfo).bViewCharacter )
		{
		Sender.PlaySound (Sound'BotPack.flak.Click',,2.0);
		if (US_PRI(Sender.PlayerReplicationInfo).CurrentItem == "Item1")
			{
			US_PRI(Sender.PlayerReplicationInfo).CurrentItem = "Item3";
			}
		else if (US_PRI(Sender.PlayerReplicationInfo).CurrentItem == "Item3")
			{
			US_PRI(Sender.PlayerReplicationInfo).CurrentItem = "Item2";
			}
		else if (US_PRI(Sender.PlayerReplicationInfo).CurrentItem == "Item2")
			{
			US_PRI(Sender.PlayerReplicationInfo).CurrentItem = "Item1";
			}
		}
	//log("Mutatorcommand given:"@MutateString);

	if ( NextMutator != None )
		NextMutator.Mutate(MutateString, Sender);
}


function bool CheckReplacement(Actor Other, out byte bSuperRelevant)
{

// here we need to get rid of the weapons and the default pickups in the map.

	if ( Other.IsA('enforcer') || Other.IsA('ChainSaw') || Other.IsA('ImpactHammer')
		|| Other.IsA('minigun2') || Other.IsA('PulseGun') || Other.IsA('ripper')
		|| Other.IsA('ShockRifle') || Other.IsA('SniperRifle') || Other.IsA('ut_biorifle')
		|| Other.IsA('UT_Eightball') || Other.IsA('UT_FlakCannon') || Other.IsA('HealthVial')
		|| Other.IsA('HealthPackage') || Other.IsA('MedBox') )
		{
		return false;
		}
	if ( Other.IsA('Ammo') && !Other.IsA('US_Ammo') && !Other.IsA('WarHeadAmmo') )
		{
		return false;
		}

	return true;
}

function bool PreventDeath (Pawn Killed, Pawn Killer, name damageType, vector HitLocation)
{
local Inventory Inv;
local int Dice;
local bool bHasDroppedItem;
local actor dropped;
local float speed;

if ( Killed != None && Killer != None )
	{
	if ( Killed.Inventory != none )
		{
		for (inv=Killed.Inventory; inv!=None; inv=inv.Inventory)
			{
			Killed.Inventory.Destroy();
			}
		}

	if ( Killed.IsA('US_Monster') && US_Monster(Killed).bIsBoss && Killed.IsA('US_Boss_Pupella') || Killed.IsA('US_Boss_TheRock') || Killed.IsA('US_Boss_Aliella') || Killed.IsA('US_Boss_Turok') || Killed.IsA('US_Boss_HellSniper') )
		{
		US_PRI(Killer.PlayerReplicationInfo).BossesKilled++;
		DropBossSoul(Killed, Killer);
		}
	else if ( Killer.IsA('PlayerPawn') )
		{
		DropSoul(Killed, Killer);
		}

	if ( Killer.IsA('PlayerPawn') )
		{
		//Calculate chance to drop crate pickup:
		Dice = Rand(60);
		if ( Dice == 0 )
			{
			DropCrate(Killed);
			bHasDroppedItem = True;
			}
		//Calculate chance to drop Dollar pickup:
		Dice = Rand(25);
		if ( !bHasDroppedItem && Dice == 0 )
			{
			DropDollar(Killed);
			bHasDroppedItem = True;
			}
		//Calculate chance to drop HealthPoint pickup:
		Dice = Rand(12);
		if ( !bHasDroppedItem && Dice == 0 )
			{
			DropHealthPoint(Killed);
			bHasDroppedItem = True;
			}
		//Calculate chance to drop SuperHealthPoint pickup:
		Dice = Rand(14);
		if ( !bHasDroppedItem && Dice == 0 )
			{
			DropSuperHealthPoint(Killed);
			bHasDroppedItem = True;
			}
		//Calculate chance to drop Armor2 pickup:
		Dice = Rand(15);
		if ( !bHasDroppedItem && Dice == 0 )
			{
			DropArmor2(Killed);
			bHasDroppedItem = True;
			}
		//Calculate chance to drop UT_ShieldBelt pickup:
		Dice = Rand(16);
		if ( !bHasDroppedItem && Dice == 0 )
			{
			DropShieldBelt(Killed);
			bHasDroppedItem = True;
			}
		//Calculate chance to drop ThighPads pickup:
		Dice = Rand(12);
		if ( !bHasDroppedItem && Dice == 0 )
			{
			DropThighPads(Killed);
			bHasDroppedItem = True;
			}
		//Calculate chance to drop a weapon:
		Dice = Rand(8); //8 seems to be a good value
		if ( !bHasDroppedItem && Dice == 0 )
			{
			DropWeapon(Killed);
			bHasDroppedItem = True;
			}
		//Calculate chance to drop a statpoint:
		Dice = Rand(75);
		if ( !bHasDroppedItem && Dice == 0 )
			{
			DropStatPoint(Killed);
			bHasDroppedItem = True;
			}
		}


	if ( Killed.IsA('PlayerPawn') )
		{
		US_PRI(Killed.PlayerReplicationInfo).bHasSpeed = False;
		US_PRI(Killed.PlayerReplicationInfo).bHasDamage = False;
		US_PRI(Killed.PlayerReplicationInfo).bHasDefense = False;
		US_PRI(Killed.PlayerReplicationInfo).bHasAura = False;
		US_PRI(Killed.PlayerReplicationInfo).bHasHealthRegenRelic = False;
		US_PRI(Killed.PlayerReplicationInfo).bHasRadar = False;
		
		Killed.JumpZ = Killed.default.JumpZ * 1.1;
		Killed.GroundSpeed = Killed.default.GroundSpeed;
		Killed.WaterSpeed = Killed.default.WaterSpeed;
		Killed.AirSpeed = Killed.default.AirSpeed;
		Killed.Acceleration = Killed.default.Acceleration;
		Killed.Texture = Killed.Default.Texture;
		Killed.bMeshEnviromap = Killed.Default.bMeshEnviromap;
		Killed.Style = Killed.Default.Style;
		Killed.DamageScaling = 1.0;
		}
	
	if ( NextMutator != None )
		{
		NextMutator.PreventDeath(Killer, Killed, damageType, HitLocation);
		//NextMutator.ScoreKill(Killer, Killed);
		}
	}
}

function DropWeapon(Pawn Other)
{
local Weapon DropItem;
//local UniversalSoldiersWeapon DropItem;
local float 	speed;
local int dice;

	dice = Rand(20);

//	DropItem = Spawn(Class'USW_Quadshot',,,Other.Location);

	if ( dice == 0 )
		DropItem = Spawn(Class'USW_AssaultRifle',,,Other.Location);
	else if ( dice == 1 )
		DropItem = Spawn(Class'USW_Barret50',,,Other.Location);
	else if ( dice == 2 )
		DropItem = Spawn(Class'USW_BioRifle',,,Other.Location);
	else if ( dice == 3 )
		DropItem = Spawn(Class'USW_Eightball',,,Other.Location);
	else if ( dice == 4 )
		DropItem = Spawn(Class'USW_Enforcer',,,Other.Location);
	else if ( dice == 5 )
		DropItem = Spawn(Class'USW_FlakCannon',,,Other.Location);
	else if ( dice == 6 )
		DropItem = Spawn(Class'USW_Lawgiver',,,Other.Location);
	else if ( dice == 7 )
		DropItem = Spawn(Class'USW_MiniGun',,,Other.Location);
	else if ( dice == 8 )
		DropItem = Spawn(Class'USW_Painless',,,Other.Location);
	else if ( dice == 9 )
		DropItem = Spawn(Class'USW_PulseGun',,,Other.Location);
	else if ( dice == 10 )
		DropItem = Spawn(Class'USW_RazorJack',,,Other.Location);
	else if ( dice == 11 )
		DropItem = Spawn(Class'USW_ShockRifle',,,Other.Location);
	else if ( dice == 12 )
		DropItem = Spawn(Class'USW_SniperRifle',,,Other.Location);
	else if ( dice == 13 )
		DropItem = Spawn(Class'USW_TwinLauncher',,,Other.Location);
	else if ( dice == 14 )
		DropItem = Spawn(Class'USW_Uzi',,,Other.Location);
	else if ( dice == 15 )
		DropItem = Spawn(Class'USW_ASMD',,,Other.Location);
	else if ( dice == 16 )
		DropItem = Spawn(Class'USW_Automag',,,Other.Location);
	else if ( dice == 17 )
		DropItem = Spawn(Class'USW_DispersionPistol',,,Other.Location);
	else if ( dice == 18 )
		DropItem = Spawn(Class'USW_OldEightball',,,Other.Location);
	else if ( dice == 19 )
		DropItem = Spawn(Class'USW_Stinger',,,Other.Location);

	speed = VSize(Other.Velocity);
	DropItem.RemoteRole = ROLE_DumbProxy;
	DropItem.SetPhysics(PHYS_Falling);
	DropItem.bCollideWorld = true;
	DropItem.Velocity = Normal(Other.Velocity/speed + 0.5 * VRand()) * (speed + 320);
	DropItem.RespawnTime = 0.0;
	DropItem.bRotatingPickup=True;

}

function DropCrate(Pawn Other)
{
local Pickup_Crate DropItem;
local float 	speed;

	speed = VSize(Other.Velocity);

	DropItem = Spawn(Class'Pickup_Crate',,,Other.Location);
	DropItem.RemoteRole = ROLE_DumbProxy;
	DropItem.SetPhysics(PHYS_Falling);
	DropItem.bCollideWorld = true;
	DropItem.Velocity = Normal(Other.Velocity/speed + 0.5 * VRand()) * (speed + 500);
	DropItem.RespawnTime = 0.0;
	DropItem.bRotatingPickup = False;

}

function DropSoul(Pawn Other, Pawn Killer)
{
local Pickup_Soul DropItem;

        if ((Other != none) && (Killer !=none))
        {
                DropItem = Spawn(Class'Pickup_Soul',,,Other.Location);
	        DropItem.Claimer = Killer.PlayerReplicationInfo.PlayerName;
	        DropItem.DrawScale = 0.75;
	        DropItem.RemoteRole = ROLE_DumbProxy;
	        DropItem.SetPhysics(PHYS_Falling);
	        DropItem.bCollideWorld = true;
	        DropItem.RespawnTime = 0.0;
	        DropItem.bRotatingPickup = False;
	}
}

function DropBossSoul(Pawn Other, Pawn Killer)
{
local Pickup_BossSoul DropItem;

        if ((Other != none) && (Killer !=none))
        {
                DropItem = Spawn(Class'Pickup_BossSoul',,,Other.Location);
	        DropItem.Claimer = Killer.PlayerReplicationInfo.PlayerName;
	        DropItem.DrawScale = 0.75;
	        DropItem.RemoteRole = ROLE_DumbProxy;
	        DropItem.SetPhysics(PHYS_Falling);
	        DropItem.bCollideWorld = true;
	        DropItem.RespawnTime = 0.0;
	        DropItem.bRotatingPickup = False;
	}
}

function DropStatPoint(Pawn Other)
{
local Inventory DropItem;
local float 	speed;

	DropItem = Spawn(Class'StatPoint',,,Other.Location+Vect(20,20,0));
	speed = VSize(Other.Velocity);
	DropItem.RemoteRole = ROLE_DumbProxy;
	DropItem.SetPhysics(PHYS_Falling);
	DropItem.bCollideWorld = true;
	DropItem.Velocity = Normal(Other.Velocity/speed + 0.5 * VRand()) * (speed + 320);
	DropItem.RespawnTime = 0.0;
	DropItem.bRotatingPickup=True;
}

function DropDollar(Pawn Other)
{
local Inventory	DropItem;
local float 	speed;

	DropItem = Spawn(Class'Pickup_Dollar',,,Other.Location+Vect(20,20,0));
	speed = VSize(Other.Velocity);
	DropItem.RemoteRole = ROLE_DumbProxy;
	DropItem.SetPhysics(PHYS_Falling);
	DropItem.bCollideWorld = true;
	DropItem.Velocity = Normal(Other.Velocity/speed + 0.5 * VRand()) * (speed + 320);
	DropItem.RespawnTime = 0.0;
	DropItem.bRotatingPickup=True;
}

function DropHealthPoint(Pawn Other)
{
local Inventory	DropItem;
local float 	speed;

	DropItem = Spawn(Class'Pickup_HealthPoint',,,Other.Location+Vect(20,20,0));
	speed = VSize(Other.Velocity);
	DropItem.RemoteRole = ROLE_DumbProxy;
	DropItem.SetPhysics(PHYS_Falling);
	DropItem.bCollideWorld = true;
	DropItem.Velocity = Normal(Other.Velocity/speed + 0.5 * VRand()) * (speed + 320);
	DropItem.RespawnTime = 0.0;
	DropItem.bRotatingPickup=True;
}

function DropSuperHealthPoint(Pawn Other)
{
local Inventory	DropItem;
local float 	speed;

	DropItem = Spawn(Class'Pickup_SuperHealthPoint',,,Other.Location+Vect(20,20,0));
	speed = VSize(Other.Velocity);
	DropItem.RemoteRole = ROLE_DumbProxy;
	DropItem.SetPhysics(PHYS_Falling);
	DropItem.bCollideWorld = true;
	DropItem.Velocity = Normal(Other.Velocity/speed + 0.5 * VRand()) * (speed + 320);
	DropItem.RespawnTime = 0.0;
	DropItem.bRotatingPickup=True;
}

function DropArmor2(Pawn Other)
{
local Inventory	DropItem;
local float 	speed;

	DropItem = Spawn(Class'Armor2',,,Other.Location+Vect(20,20,0));
	speed = VSize(Other.Velocity);
	DropItem.RemoteRole = ROLE_DumbProxy;
	DropItem.SetPhysics(PHYS_Falling);
	DropItem.bCollideWorld = true;
	DropItem.Velocity = Normal(Other.Velocity/speed + 0.5 * VRand()) * (speed + 320);
	DropItem.RespawnTime = 0.0;
	DropItem.bRotatingPickup=True;
}

function DropShieldBelt(Pawn Other)
{
local Inventory	DropItem;
local float 	speed;

	DropItem = Spawn(Class'UT_ShieldBelt',,,Other.Location+Vect(20,20,0));
	speed = VSize(Other.Velocity);
	DropItem.RemoteRole = ROLE_DumbProxy;
	DropItem.SetPhysics(PHYS_Falling);
	DropItem.bCollideWorld = true;
	DropItem.Velocity = Normal(Other.Velocity/speed + 0.5 * VRand()) * (speed + 320);
	DropItem.RespawnTime = 0.0;
	DropItem.bRotatingPickup=True;
}

function DropThighPads(Pawn Other)
{
local Inventory	DropItem;
local float 	speed;

	DropItem = Spawn(Class'ThighPads',,,Other.Location+Vect(20,20,0));
	speed = VSize(Other.Velocity);
	DropItem.RemoteRole = ROLE_DumbProxy;
	DropItem.SetPhysics(PHYS_Falling);
	DropItem.bCollideWorld = true;
	DropItem.Velocity = Normal(Other.Velocity/speed + 0.5 * VRand()) * (speed + 320);
	DropItem.RespawnTime = 0.0;
	DropItem.bRotatingPickup=True;
}

defaultproperties
{
}
